% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actionBttn.R
\name{downloadBttn}
\alias{downloadBttn}
\title{Create a download bttn}
\usage{
downloadBttn(outputId, label = "Download", style = "unite",
  color = "default", size = "md", block = FALSE, no_outline = TRUE)
}
\arguments{
\item{outputId}{The name of the output slot that the \code{downloadHandler} is assigned to.}

\item{label}{The label that should appear on the button.}

\item{style}{Style of the button, to choose between \code{simple}, \code{bordered},
\code{minimal}, \code{stretch}, \code{jelly}, \code{gradient}, \code{fill},
\code{material-circle}, \code{material-flat}, \code{pill}, \code{float}, \code{unite}.}

\item{color}{Color of the button : \code{default}, \code{primary}, \code{warning},
\code{danger}, \code{success}, \code{royal}.}

\item{size}{Size of the button : \code{xs},\code{sm}, \code{md}, \code{lg}.}

\item{block}{Logical, full width button.}

\item{no_outline}{Logical, don't show outline when navigating with
keyboard/interact using mouse or touch.}
}
\description{
Create a download button with \link{actionBttn}.
}
\examples{
\dontrun{

if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Download bttn"),
  downloadBttn(
    outputId = "downloadData",
    style = "bordered",
    color = "primary"
  )
)

server <- function(input, output, session) {

  output$downloadData <- downloadHandler(
    filename = function() {
      paste('data-', Sys.Date(), '.csv', sep='')
    },
    content = function(con) {
      write.csv(mtcars, con)
    }
  )

}

shinyApp(ui, server)

}

}
}
