% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-dropdown.R
\name{dropdownButton}
\alias{dropdownButton}
\title{Dropdown Button}
\usage{
dropdownButton(..., circle = TRUE, status = "default", size = "default",
  icon = NULL, label = NULL, tooltip = FALSE, right = FALSE,
  up = FALSE, width = NULL, inputId = NULL)
}
\arguments{
\item{...}{List of tag to be displayed into the dropdown menu.}

\item{circle}{Logical. Use a circle button}

\item{status}{Add a class to the buttons, you can use Bootstrap status like 'info', 'primary', 'danger', 'warning' or 'success'.
Or use an arbitrary strings to add a custom class, e.g. : with \code{status = 'myClass'}, buttons will have class \code{btn-myClass}.}

\item{size}{Size of the button : default, lg, sm, xs.}

\item{icon}{An icon to appear on the button.}

\item{label}{Label to appear on the button. If circle = TRUE and tooltip = TRUE, label is used in tooltip.}

\item{tooltip}{Put a tooltip on the button, you can customize tooltip with \code{tooltipOptions}.}

\item{right}{Logical. The dropdown menu starts on the right.}

\item{up}{Logical. Display the dropdown menu above.}

\item{width}{Width of the dropdown menu content.}

\item{inputId}{Optional, id for the button, the button act like an \code{actionButton},
and you can use the id to toggle the droddown menu server-side.}
}
\description{
Create a dropdown menu with Bootstrap
}
\examples{
\dontrun{
## Only run examples in interactive R sessions
if (interactive()) {

dropdownButton(
 "Your contents goes here ! You can pass several elements",
 circle = TRUE, status = "danger", icon = icon("gear"), width = "300px",
 tooltip = tooltipOptions(title = "Click to see inputs !")
)

}
}
}
