% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eLTTB_aggregator.R
\docType{class}
\name{eLTTB_aggregator}
\alias{eLTTB_aggregator}
\title{Aggregation using local minimum and maximum values,
and Largest Triangle Three Buckets (LTTB) method.}
\format{
An \code{R6::R6Class} object
}
\description{
Efficient version off LTTB
by first reducing really large data with the \code{min_max_ovlp_aggregator}
and then further aggregating the reduced result with \code{LTTB_aggregator}.
}
\examples{
data(noise_fluct)
agg <- eLTTB_aggregator$new(interleave_gaps = TRUE)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500, 1000)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")

}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{eLTTB_aggregator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{LTTB}}{An R6 LTTB_aggregator instance}

\item{\code{minmax}}{An R6 \code{min_max_ovlp_aggregator} instance}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-eLTTB_aggregator-new}{\code{eLTTB_aggregator$new()}}
\item \href{#method-eLTTB_aggregator-clone}{\code{eLTTB_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eLTTB_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-eLTTB_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{eLTTB_aggregator$new(
  ...,
  interleave_gaps,
  coef_gap,
  NA_position,
  accepted_datatype = c("numeric", "integer", "character", "factor", "logical")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arguments pass to the constructor of \code{aggregator},
\code{LTTB_aggregator} and \code{min_max_oblp_aggregator} objects.}

\item{\code{interleave_gaps, coef_gap, NA_position, accepted_datatype}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-eLTTB_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-eLTTB_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{eLTTB_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
