% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_hugeplot.R
\name{shiny_hugeplot}
\alias{shiny_hugeplot}
\alias{shiny_hugeplot.default}
\alias{shiny_hugeplot.matrix}
\alias{shiny_hugeplot.data.frame}
\alias{shiny_hugeplot.plotly}
\alias{shiny_hugeplot.downsampler}
\title{Wrapper for plotting large-sized data using shiny and plotly}
\usage{
shiny_hugeplot(obj, ...)

\method{shiny_hugeplot}{default}(
  obj = NULL,
  y = NULL,
  tz = Sys.timezone(),
  use_light_build = TRUE,
  plotly_options = list(type = "scatter", mode = "lines"),
  plotly_layout_options = list(),
  aggregator = min_max_aggregator$new(),
  n_out = 1000L,
  run_shiny = TRUE,
  downsampler_options = list(),
  shiny_options = list(),
  width = "100\%",
  height = "600px",
  ...
)

\method{shiny_hugeplot}{matrix}(
  obj = NULL,
  n_out = 1000L,
  aggregator = min_max_aggregator$new(),
  run_shiny = TRUE,
  use_light_build = TRUE,
  downsampler_options = list(),
  plotly_options = list(type = "scatter", mode = "lines"),
  plotly_layout_options = list(),
  shiny_options = list(),
  width = "100\%",
  height = "600px",
  ...
)

\method{shiny_hugeplot}{data.frame}(
  obj = NULL,
  tz = Sys.timezone(),
  n_out = 1000L,
  aggregator = min_max_aggregator$new(),
  run_shiny = TRUE,
  use_light_build = TRUE,
  downsampler_options = list(),
  plotly_options = list(type = "scatter", mode = "lines"),
  plotly_layout_options = list(),
  shiny_options = list(),
  width = "100\%",
  height = "600px",
  ...
)

\method{shiny_hugeplot}{plotly}(
  obj,
  n_out = 1000L,
  aggregator = min_max_aggregator$new(),
  run_shiny = TRUE,
  use_light_build = TRUE,
  downsampler_options = list(),
  shiny_options = list(),
  width = "100\%",
  height = "600px",
  ...
)

\method{shiny_hugeplot}{downsampler}(
  obj,
  run_shiny = TRUE,
  shiny_options = list(),
  width = "100\%",
  height = "600px",
  ...
)
}
\arguments{
\item{obj}{Numeric vector, nanotime vector, numeric matrix, data.frame,
or plotly object.
If a numeric vector is given, it is used as the y values of the figure.
the x values are calculated by \code{seq_along(obj)}.
If you use \code{y} argument together, this argument is interpreted as
the x values of the figure.
If a nanotime vector is given, it is used as the x values of the figure.
You must also give \code{y} argument, which will be used as the y values.
Regarding \code{nanotime}, see the \code{nanotime} package.
If a numeric matrix is given, the first and second column values are used
as the x and y values. (The matrix must have more than 2 columns.)
If a data.frame is given, \code{x} and \code{y} columns are used as the
x and y values. If the class of the \code{x} column is \code{nanotime},
the date type will be applied to the x axis.
The data.frame must have columns named x and y.
If a plotly object is given, it will be displayed.}

\item{...}{Not used.}

\item{y}{Numeric vector, optional.
The y values of the figure.
It is required if the \code{obj} argument is used as x values of the figure.}

\item{tz}{Timezone, optional.
It is used to convert the nanotime to the time displayed in the figure.
It is used if the class of the \code{obj} argument is nanotime.
By default, \code{Sys.timezone()}.}

\item{use_light_build}{Boolean, optional.
Whether a light version of the plotly data builder
(\code{plotly_data_light}) implemented in this package is used.
By default, \code{TRUE}.}

\item{plotly_options}{Named list, optional.
Arguments passed to \code{plotly::plot_ly}.}

\item{plotly_layout_options}{Named list, optional.
Arguments passed to \code{plotly::layout}.}

\item{aggregator}{R6 class for the aggregation, optional.
Select an aggregation function. The list of the functions are obtained
using \code{list_aggregators}.
By default, \code{min_max_aggregator$new()}.}

\item{n_out}{Integer, optional.
Number of samples get by the down-sampling. By default, 1000.}

\item{run_shiny}{Boolean, optional.
whether a generated shiny app will be run immediately.
By default, \code{TRUE}.}

\item{downsampler_options}{Named list, optional.
Arguments passed to \code{shiny_downsampler$new}, other than
\code{aggregator} and \code{n_shown_samples}.
To set these arguments, use \code{aggregator} and \code{n_out} arguments.}

\item{shiny_options}{Named list, optional.
Arguments passed to \code{shinyApp} function.}

\item{width, height}{Character, optional.
Arguments passed to \code{plotlyOutput}.
By default, \code{100\%} and \code{600px}.}
}
\description{
This S3 class function is a wrapper to plot the large-sized data.
It employs an R6 \code{shiny_downsampler} instance to obtain data samples
using a specified aggregation method that is defined in the instance.
The figure will be updated interactively according to the x-range
that user select manually in the shiny app.
}
\examples{
\donttest{
data(noise_fluct)

shiny_hugeplot(noise_fluct$f500)
shiny_hugeplot(noise_fluct$time, noise_fluct$f500)
}
}
