% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregators.R
\docType{class}
\name{custom_func_aggregator}
\alias{custom_func_aggregator}
\title{R6 Class for Aggregation using a user-defined function.}
\format{
An \code{R6::R6Class} object
}
\description{
Arbitrary function can be applied using this aggregation class.
}
\examples{
custom_agg_func <- function(x, y, n_out) {
  bin_width <- floor(length(x)/n_out)
  x_idx <- seq(floor(bin_width / 2), bin_width * n_out, bin_width)
  y_mat <- y[1:(bin_width * n_out)] \%>\%
    matrix(nrow = bin_width)
  y_agg <- apply(y_mat, 2, quantile, probs = 0.25)
  return(list(x = x[x_idx], y = y_agg))
}
data(noise_fluct)
agg <- custom_func_aggregator$new(custom_agg_func)
d_agg <- agg$aggregate(noise_fluct$sec, noise_fluct$level, 1000)
plot(d_agg$x, d_agg$y, type = "l")

}
\section{Super class}{
\code{\link[shinyHugePlot:abstract_aggregator]{shinyHugePlot::abstract_aggregator}} -> \code{custom_func_aggregator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{aggregation_func}}{User-defined function to aggregate data,
of which arguments are \code{x}, \code{y} and \code{n_out}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-custom_func_aggregator-new}{\code{custom_func_aggregator$new()}}
\item \href{#method-custom_func_aggregator-clone}{\code{custom_func_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="abstract_aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/abstract_aggregator.html#method-abstract_aggregator-aggregate'><code>shinyHugePlot::abstract_aggregator$aggregate()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_func_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-custom_func_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_func_aggregator$new(
  aggregation_func,
  interleave_gaps = FALSE,
  nan_position = "end",
  accepted_datatype = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aggregation_func}}{User-defined function to aggregate data,
of which arguments are \code{x}, \code{y} and \code{n_out}.}

\item{\code{interleave_gaps, nan_position, accepted_datatype}}{Arguments pass to the constructor of
the \code{abstract_aggregator} class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_func_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-custom_func_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_func_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
