% Generated by roxygen2 (4.0.1): do not edit by hand
\name{shinyFilesButton}
\alias{shinyFilesButton}
\title{Create a button to summon the file system navigator}
\usage{
shinyFilesButton(inputId, label, title, multiple)
}
\arguments{
\item{inputId}{Input variable to assign the control's value to}

\item{label}{The text that should appear on the button}

\item{title}{The heading of the dialog box that appears when the button is
pressed}

\item{multiple}{A logical indicating whether or not it should be possible to
select multiple files}
}
\description{
This function adds the required html markup for the client to access the file
system. The end result will be the appearance of a button on the webpage that
summons the file system navigator dialog box. The last position in the file
system is automatically remembered between instances, but not shared between
several shinyFiles buttons. After adding a shinyFiles button the selected
file(s) will be available in \code{input$inputId} (providing \code{input} is
the name of the input object in the \code{shinyServer()} call). The file
names should be parsed with \code{\link{parseFilePaths}} before usage though,
to make them compliant with the \code{\link[shiny]{fileInput}} function.
}
\details{
When a user selects one or several files the corresponding input variable is
set to a list containing a character vector for each file. The character
vectors gives the traversal route from the root to the selected file(s). The
reason it does not give a path as a string is that the client has no
knowledge of the file system on the server and can therefore not ensure
proper formatting. As described above the input variable should be wrapped in
a call to \code{\link{parseFilePaths}} for a more beautiful output.

For users wanting to design their html markup manually it is very easy to add
a shinyFiles button. The only markup required is:

\code{<button id="inputId" type="button" class="shinyFiles btn" data-title="title" data-selecttype="single"|"multiple">label</button>}

where the id tag matches the inputId parameter, the data-title tag matches
the title parameter, the data-selecttype is either "single" or "multiple" (
the non-logical form of the multiple parameter) and the internal textnode
mathces the label parameter.

Apart from this the html document should link to a script with the
following path 'sF/shinyFiles.js' and a stylesheet with the following path
'sF/styles.css'.

The markup is bootstrap compliant so if the bootstrap css is used in the page
the look will fit right in. There is nothing that hinders the developer from
ignoring bootstrap altogether and designing the visuals themselves. The only
caveat being that the glyphs used in the menu buttons are bundled with
bootstrap. Use the css ::after pseudoclasses to add alternative content to
these buttons. Additional filetype specific icons can be added with css using
the following style:

.sF-file .sF-file-icon .yourFileExtension{
content: url(path/to/16x16/pixel/png);
}
.sF-fileList.sF-icons .sF-file .sF-file-icon .yourFileExtension{
content: url(path/to/32x32/pixel/png);
}

If no large version is specified the small version gets upscaled.
}
\references{
The file icons used in the file system navigator is taken from
FatCows Farm-Fresh Web Icons (\url{http://www.fatcow.com/free-icons})
}
\seealso{
Other shinyFiles: \code{\link{parseFilePaths}};
  \code{\link{shinyFileChoose}};
  \code{\link{shinyFilesExample}}
}

