% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confints.R
\name{surv_pred_info}
\alias{surv_pred_info}
\title{Obtains information for standard errors of predictions}
\usage{
surv_pred_info(model, ctype, individual = FALSE, id, se.fit = TRUE, stype = 2)
}
\arguments{
\item{model}{a \code{coxph} object}

\item{ctype}{whether the cumulative hazard computation should have a
correction for ties, 1=no, 2=yes.}

\item{individual}{deprecated argument, replaced by \code{id}}

\item{id}{optional variable name of subject identifiers. Not supported in app}

\item{se.fit}{a logical value indicating whether standard errors should be
computed. Default is TRUE for standard models, FALSE for multi-state (code
not yet present for that case.)}

\item{stype}{computation of the survival curve, 1=direct, 2=exponential of
the cumulative hazard. Default is 2.}
}
\value{
A list of information needed for computing predicted standard
errors.
}
\description{
Computes necessary information to calculate standard errors and
confidence intervals in shiny app. This is adapted from parts of
\code{\link[survival:survfit.coxph]{survival::survfit.coxph()}}. This function is meant to be used in conjunction with
\code{\link[=predict_se]{predict_se()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(survival)

colondeaths <- colon[colon$etype == 2, ]
split_colon <- split(colondeaths, colondeaths$rx)
colon_arm1 <- split_colon$Obs

colon1ph <- coxph(Surv(time, status) ~ factor(extent) + nodes + strata(surg)
                   + factor(differ),
                   colon_arm1,
                   x = TRUE, model = TRUE)
surv_pred_info(colon1ph)
\dontshow{\}) # examplesIf}
}
