% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{extendMutabilityMatrix}
\alias{extendMutabilityMatrix}
\title{Extends a mutability model to include Ns.}
\usage{
extendMutabilityMatrix(mutabilityModel)
}
\arguments{
\item{mutabilityModel}{vector of 5-mer mutability rates built by 
\code{\link{createMutabilityMatrix}}.}
}
\value{
A 3125 vector of normalized mutability rates for each 5-mer motif with 
          names defining the 5-mer nucleotide sequence.
}
\description{
\code{extendMutabilityMatrix} extends a 5-mer nucleotide mutability model 
with 5-mers that include Ns by averaging over all corresponding 5-mers without Ns.
}
\examples{
# Subset example data to one isotype and sample as a demo
db <- subset(InfluenzaDb, CPRIMER == "IGHA" & BARCODE == "RL014")

# Create model using only silent mutations and ignore multiple mutations
sub_model <- createSubstitutionMatrix(db, model="S", multipleMutation="ignore")
mut_model <- createMutabilityMatrix(db, sub_model, model="S", multipleMutation="ignore",
                                    minNumSeqMutations=10)
ext_model <- extendMutabilityMatrix(mut_model)

}
\seealso{
Other targeting model functions: \code{\link{calcTargetingDistance}},
  \code{\link{createMutabilityMatrix}},
  \code{\link{createSubstitutionMatrix}},
  \code{\link{createTargetingMatrix}},
  \code{\link{createTargetingModel}},
  \code{\link{extendSubstitutionMatrix}},
  \code{\link{plotMutability}},
  \code{\link{writeTargetingDistance}}
}

