\name{plotProfileDendrogram}
\alias{plotProfileDendrogram}
\title{Plot soil profiles below a dendrogram}
\description{Plot soil profiles below a dendrogram}
\usage{
plotProfileDendrogram(x, clust, scaling.factor = 0.01, width = 0.1, 
y.offset = 0.1, dend.y.scale = max(clust$height * 2, na.rm = TRUE), 
debug = FALSE, ...)
}

\arguments{
  \item{x}{a \code{SoilProfileCollection} object}
  \item{clust}{a hierachical clustering object generated by \code{cluster::agnes()} or \code{cluster::diana()}}
  \item{scaling.factor}{vertical scaling of the profile heights (may have to tinker with this)}
  \item{width}{scaling of profile widths}
  \item{y.offset}{vertical offset for top of profiles}
  \item{dend.y.scale}{extent of y-axis (may have to tinker with this)}
  \item{debug}{optionally print debugging data}
  \item{\dots}{additional arguments to \code{plotSPC}}
}

\details{This function places soil profile sketches below a dendrogram.}

\note{You may have to tinker with some of the arguments to get optimal arrangement and scaling of soil profiles.}

\author{D.E. Beaudette}

\seealso{\code{\link{plotSPC}}}

\keyword{ hplots }

