% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulations.R
\name{SamplePredictors}
\alias{SamplePredictors}
\title{Simulation of binary contribution status}
\usage{
SamplePredictors(pk, q = NULL, nu = 0.1, orthogonal = TRUE)
}
\arguments{
\item{pk}{vector of the number of variables per group, defining the block
structure.}

\item{q}{number of outcome variables. By default, one block of predictor is
linked to one outcome, i.e. \code{q=sum(pk)}.}

\item{nu}{vector of probabilities. Each entry corresponds to one block of
predictors and defines the probability for each predictor within the block
to be chosen as true predictor of the corresponding outcome variable.}

\item{orthogonal}{logical indicating if the outcomes have to be defined from
independent blocks of predictors as encoded in \code{pk}.}
}
\value{
A binary matrix encoding the contribution status of each predictor
  variable (columns) to each outcome variable (rows).
}
\description{
Simulates the binary contribution status of potential predictor variables
from different blocks to outcome variables. For each outcome, the set of true
predictors is sampled from one block of potential predictors. If the blocks
of variables are independent, the outcomes will be independent too.
}
\keyword{internal}
