% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{vaeac_normal_parse_params}
\alias{vaeac_normal_parse_params}
\title{Creates Normal Distributions}
\usage{
vaeac_normal_parse_params(params, min_sigma = 1e-04)
}
\arguments{
\item{params}{Tensor of dimension \code{batch_size} x \code{2*n_featuers} containing the means and standard deviations
to be used in the normal distributions for of the \code{batch_size} observations.}

\item{min_sigma}{For stability it might be desirable that the minimal sigma is not too close to zero.}
}
\value{
A \code{\link[torch:distr_normal]{torch::distr_normal()}} distribution with the provided means and standard deviations.
}
\description{
Function that takes in the a tensor where the first half of the columns contains the means of the
normal distributions, while the latter half of the columns contains the standard deviations. The standard deviations
are clamped with \code{min_sigma} to ensure stable results. If \code{params} is of dimensions batch_size x 8, the function
will create 4 independent normal distributions for each of the observation (\code{batch_size} observations in total).
}
\details{
Take a Tensor (e.g. neural network output) and return a \code{\link[torch:distr_normal]{torch::distr_normal()}} distribution.
This normal distribution is component-wise independent, and its dimensionality depends on the input shape.
First half of channels is mean (\eqn{\mu}) of the distribution, the softplus of the second half is
std (\eqn{\sigma}), so there is no restrictions on the input tensor. \code{min_sigma} is the minimal value of
\eqn{\sigma}. I.e., if the above softplus is less than \code{min_sigma}, then \eqn{\sigma} is clipped
from below with value \code{min_sigma}. This regularization is required for the numerical stability and may
be considered as a neural network architecture choice without any change to the probabilistic model.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
