% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{predict_model}
\alias{predict_model}
\alias{predict_model.default}
\alias{predict_model.lm}
\alias{predict_model.glm}
\alias{predict_model.ranger}
\alias{predict_model.xgb.Booster}
\alias{predict_model.gam}
\title{Generate predictions for different model classes}
\usage{
predict_model(x, newdata)

\method{predict_model}{default}(x, newdata)

\method{predict_model}{lm}(x, newdata)

\method{predict_model}{glm}(x, newdata)

\method{predict_model}{ranger}(x, newdata)

\method{predict_model}{xgb.Booster}(x, newdata)

\method{predict_model}{gam}(x, newdata)
}
\arguments{
\item{x}{Model object for the model to be explained.}

\item{newdata}{A data frame (or matrix) in which to look for variables with which to predict.}
}
\value{
Numeric
}
\description{
Performs prediction of response \code{\link[stats]{lm}}, \code{\link[stats]{glm}},
\code{\link[ranger]{ranger}},  \code{\link[mgcv:gam]{mgcv::gam}} and
\code{\link[xgboost:xgb.train]{xgboost::xgb.train}} with binary or continuous
response. See details for more information.
}
\details{
The following models are currently supported:
\itemize{
\item \code{\link[stats:lm]{stats::lm}}
\item \code{\link[stats:glm]{stats::glm}}
\item \code{\link[ranger:ranger]{ranger::ranger}}
\item \code{\link[mgcv:gam]{mgcv::gam}}
\item \code{\link[xgboost:xgb.train]{xgboost::xgb.train}}
}

The returned object \code{p} always satisfies the following properties:
\itemize{
\item \code{is.atomic(p)} equals \code{TRUE}
\item \code{is.double(p)} equals \code{TRUE}
}

If you have a binary classification model we'll always return the probability prediction
for a single class.

For more details on how to use a custom model see the package vignette: \cr
\code{vignette("understanding_shapr", package = "shapr")}
}
\examples{
# Load example data
data("Boston", package = "MASS")
# Split data into test- and training data
x_train <- head(Boston, -3)
x_test <- tail(Boston, 3)
# Fit a linear model
model <- lm(medv ~ lstat + rm + dis + indus, data = x_train)

# Predicting for a model with a standardized format
predict_model(x = model, newdata = x_test)
}
\author{
Martin Jullum
}
\keyword{internal}
