% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_growth_model.R
\name{plot_sgmod}
\alias{plot_sgmod}
\title{plot_sgmod}
\usage{
plot_sgmod(x, ...)
}
\arguments{
\item{x}{A \code{sgmod} object.}

\item{...}{Additional arguments.}
}
\value{
It returns a plot using \code{ggplot} that graphs the \code{Savings} decisions from the \code{sgmodel} object on the \code{Capital grid}. The plot shows as many facets as \code{length(Z)} where \code{Z} is the vector of states of the TFP process.
}
\description{
The function \code{plot_sgmod} returns a plot of the \code{Savings} value of a \code{sgmodel} object on the \code{Capital grid} value.
}
\examples{
model <- sgmodel( grid = 100, rho = 0.2, sigma = 0.02)
plot_sgmod(model)
grid <- 200
utiltype <- "CRRA"
utilparam <- 4
A <- 1
depre <- 0.03
discount <- 0.95
prod <- 0.3
states <- 5
m <- 2
rho <- 0.2
sigma <- 0.02
model <- sgmodel(grid, utiltype, utilparam, A, depre, discount, prod, states, m, rho, sigma)
plot_sgmod(model)
}
\references{
Wickham H (2009), ggplot2: Elegant Graphics for Data Analysis.
URL \url{http://ggplot2.org}
}
