% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootglg.R
\name{bootglg}
\alias{bootglg}
\title{Bootstrap inference for a generalized log-gamma distribution}
\usage{
bootglg(y, R, alpha, method)
}
\arguments{
\item{y}{vector, a numeric random sample.}

\item{R}{integer, represents the number of replications. Default value is 1000.}

\item{alpha}{numeric, represents a confidence level for the bootstrap intervals. Default value is 0.05.}

\item{method}{character, indicates the type of bootstrap 'Nonparametric' or 'Parametric'. Default value is 'Parametric'.}
}
\value{
ml_estimates is a vector of maximum likelihood estimates asociated with the location,scale and shape parameters.

boot_mean_estimates is a vector of mean of the bootstrap estimates asociated with the location,scale and shape parameters.

boot_sd_estimates is a vector of bootstrap standard errors of the estimates asociated with the location,scale and shape parameters.
}
\description{
\code{bootglg} is used to generate bootstrap inference, such as, estimations, standard errors, intervals for the parameters of a generalized log-gamma distribution.
}
\examples{
set.seed(1)
y <- rglg(100,location=1,scale=0.5,shape=1)
\dontrun{
bootglg(y,R=300,method='Parametric')
}
}
\references{
Cardozo C, Paula G and Vanegas L. sglg: An R package for fitting semi-parametric generalized log-gamma regression models. In preparation.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>, G. Paula and L. Vanegas.
}
