% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf_point}
\alias{sf_point}
\title{sf POINT}
\usage{
sf_point(obj, x = NULL, y = NULL, z = NULL, m = NULL, keep = FALSE)
}
\arguments{
\item{obj}{sorted vector, matrix or data.frame}

\item{x}{x geometry column}

\item{y}{y geometry column}

\item{z}{z geometry column}

\item{m}{m geometry column}

\item{keep}{logical indicating if the non-geometry and non-id columns should be kept.
if TRUE you must supply the geometry and id columns, and only the first row of
each geometry is kept. See Keeping Properties.}
}
\value{
\code{sf} object of POINT geometries
}
\description{
constructs sf of POINT objects
}
\section{Keeping Properties}{


Setting \code{keep = TRUE} will retain the first row of any columns not specified as a
coordinate (x, y, z, m) or an id (e.g., linestring_id, polygon_id) of the input \code{obj}.

The \code{sf_*} functions assume the input \code{obj} is a long data.frame / matrix,
where any properties are repeated down the table for the same geometry.
}

\section{notes}{

sfheaders functions do not perform any validity checks on the geometries.
Nor do they set Coordinate Reference Systems, EPSG, PROJ4 or precision attributes.

The data.frame and matrices you send into the sfheader functions must be ordered.
}

\examples{

x <- c(1:3)
sf_point( x )

x <- matrix( c(1:10) , ncol = 2 )
sf_point( x )

x <- setNames( as.data.frame( x ), c("x","y") )
sf_point( x )
sf_point( obj = x, x = "x", y = "y" )
sf_point( obj = x, x = "y", y = "x" )

# keeping properties
x$val <- letters[1:5]
sf_point( x, x = "x", y = "y", keep = TRUE )

}
