% Generated by roxygen2 (4.0.2): do not edit by hand
\name{reset_par}
\alias{reset_par}
\title{Reset graphical options in 'par' to factory defaults.}
\usage{
reset_par()
}
\description{
Reset the \code{\link[graphics]{par}} to R's defaults.
}
\details{
Some of \code{par}'s settings are readonly. These are obviously not reset.

Settings stored in \code{\link[graphics]{par}} are device-dependent. In practice,
most settings in \code{par} are initially the same accross devices. Exceptions
we noted are:
\itemize{
\item{\code{bg}: background color}
\item{\code{fin}: figure region dimensions}
\item{\code{mai}: margin size (inches)}
\item{\code{pin}: current plot dimensions (inches)}
\item{\code{plt}: coordinates of the plot region as fractions of the current figure region}
\item{\code{ps}: point size of text (but not symbos)}
}
Consequently, these options are currently not reset by calling \code{reset_par()}
}
\seealso{
\code{\link{reset_options}}, \code{\link[graphics]{par}}
}

