% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_Interval_SpecialSet.R
\name{ExtendedReals}
\alias{ExtendedReals}
\title{Set of Extended Real Numbers}
\description{
The mathematical set of extended real numbers,
defined as the union of the set of reals with \eqn{\pm\infty}{±\infty}. i.e.
\deqn{R \cup \\{-\infty, \infty\\}}{R U {-\infty, \infty}}
where \eqn{R} is the set of reals.
}
\seealso{
Other special sets: 
\code{\link{Complex}},
\code{\link{Integers}},
\code{\link{Logicals}},
\code{\link{Naturals}},
\code{\link{NegIntegers}},
\code{\link{NegRationals}},
\code{\link{NegReals}},
\code{\link{PosIntegers}},
\code{\link{PosNaturals}},
\code{\link{PosRationals}},
\code{\link{PosReals}},
\code{\link{Rationals}},
\code{\link{Reals}},
\code{\link{Universal}}
}
\concept{special sets}
\section{Super classes}{
\code{\link[set6:Set]{set6::Set}} -> \code{\link[set6:Interval]{set6::Interval}} -> \code{\link[set6:SpecialSet]{set6::SpecialSet}} -> \code{\link[set6:Reals]{set6::Reals}} -> \code{ExtendedReals}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExtendedReals$new()}}
\item \href{#method-clone}{\code{ExtendedReals$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="add">}\href{../../set6/html/Set.html#method-add}{\code{set6::Set$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="multiplicity">}\href{../../set6/html/Set.html#method-multiplicity}{\code{set6::Set$multiplicity()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="print">}\href{../../set6/html/Set.html#method-print}{\code{set6::Set$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="remove">}\href{../../set6/html/Set.html#method-remove}{\code{set6::Set$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="summary">}\href{../../set6/html/Set.html#method-summary}{\code{set6::Set$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="contains">}\href{../../set6/html/Interval.html#method-contains}{\code{set6::Interval$contains()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="equals">}\href{../../set6/html/Interval.html#method-equals}{\code{set6::Interval$equals()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="isSubinterval">}\href{../../set6/html/Interval.html#method-isSubinterval}{\code{set6::Interval$isSubinterval()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Interval" data-id="isSubset">}\href{../../set6/html/Interval.html#method-isSubset}{\code{set6::Interval$isSubset()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="SpecialSet" data-id="strprint">}\href{../../set6/html/SpecialSet.html#method-strprint}{\code{set6::SpecialSet$strprint()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ExtendedReals} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtendedReals$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A new \code{ExtendedReals} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtendedReals$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
