% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testTuple}
\alias{testTuple}
\alias{checkTuple}
\alias{assertTuple}
\title{assert/check/test/Tuple}
\usage{
testTuple(object, errormsg = "This is not an R6 Tuple object")

checkTuple(object, errormsg = "This is not an R6 Tuple object")

assertTuple(object, errormsg = "This is not an R6 Tuple object")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is an R6 \code{Tuple}.
}
\examples{
testTuple(Set$new(2, 3))
testTuple(list(Set$new(2), Set$new(3)))
testTuple(Tuple$new(2, 3))
testTuple(Interval$new())
testTuple(FuzzySet$new(2, 0.1))
testTuple(FuzzyTuple$new(2, 0.1))
testTuple(ConditionalSet$new(function(x) x == 0))
}
