% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_UniversalSet.R
\name{UniversalSet}
\alias{UniversalSet}
\title{Mathematical UniversalSet}
\value{
R6 object of class UniversalSet inheriting from \link{Set}.
}
\description{
The UniversalSet is defined as the \link{Set} containing all possible elements.
}
\details{
The Universal set is the default universe to all sets, and is the largest possible set.
The Universal set contains every single possible element. We denote the Universal set with \code{V}
instead of \code{U} to avoid confusion with the union symbol. The Universal set is also responsible
for a few set paradoxes, to resolve these we use the following results:
Let \eqn{V} be the universal set, \eqn{S} be any non-universal set, and \eqn{0} the empty set, then

\deqn{V \cup S = V}{V or S = V}
\deqn{V \cap S = S}{V and S = S}
\deqn{S - V = 0}
\deqn{V^n = V}
\deqn{P(V) = V}
}
\section{Constructor}{
 \code{UniversalSet$new(...)}
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{...} \tab ANY \tab Added for consistency, ignored.

}
}

\section{Constructor Details}{
 The UniversalSet takes no arguments in construction.
}

\section{Public Fields}{

\tabular{ll}{
\strong{Field} \tab \strong{Link} \cr

\code{class} \tab \link{class} \cr
\code{elements} \tab \link{elements} \cr
\code{length} \tab \link{length} \cr
\code{lower} \tab \link{lower} \cr
\code{upper} \tab \link{upper} \cr
\code{max} \tab \link{max} \cr
\code{min} \tab \link{min} \cr
\code{range} \tab \link{range} \cr
\code{properties} \tab \link{properties} \cr
\code{traits} \tab \link{traits} \cr
\code{type} \tab \link{type} \cr
\code{universe} \tab \link{universe}
}
}

\section{Public Methods}{

\tabular{ll}{

\strong{Comparison Methods} \tab \strong{Link} \cr
\code{contains(x, all = FALSE, bound = NULL)} \tab \link{contains} \cr
\code{equals(x, all = FALSE)} \tab \link{equals} \cr
\code{isSubset(x, proper = FALSE, all = FALSE)} \tab \link{isSubset} \cr
\tab \cr \tab \cr \tab \cr
\strong{Representation Methods} \tab \strong{Link} \cr
\code{strprint(n = 2)} \tab \link{strprint} \cr
\code{print(n = 2)} \tab \link{print} \cr
\code{summary(n = 2)} \tab \link{summary} \cr
}
}

\examples{
u = UniversalSet$new()
print(u)
u$contains(c(1, letters, TRUE, Set$new()), all = TRUE)

}
\seealso{
Other sets: 
\code{\link{ConditionalSet}},
\code{\link{FuzzySet}},
\code{\link{FuzzyTuple}},
\code{\link{Interval}},
\code{\link{Set}},
\code{\link{Tuple}}
}
\concept{sets}
