% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_documentation.R
\docType{data}
\name{SeqOUT_griffin}
\alias{SeqOUT_griffin}
\title{Example sequoia output (griffins)}
\format{
a list, see \code{\link{sequoia}}
}
\usage{
data(SeqOUT_griffin)
}
\description{
Example output of a sequoia run including sibship clustering,
based on the griffin pedigree.
}
\examples{
\dontrun{
GenoS <- SimGeno(Ped.griffin, nSnp=400, ParMis=0.4)
griffin.sex <- sapply(as.character(Ped_griffin$id), function(x)
                      substr(x, start=nchar(x), stop=nchar(x)))
LH.griffin <- data.frame(ID = Ped_griffin$id,
                         Sex = ifelse(griffin.sex=="F", 1, 2),
                         BirthYear = Ped_griffin$birthyear)
SeqOUT.GX <- sequoia(GenoS, LH.griffin,
                     Module = "ped",
                     args.AP = list(Smooth = FALSE))
}
}
\seealso{
\code{\link{Ped_griffin}, \link{sequoia}}
}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}
\keyword{datasets}
\keyword{sequoia}
