% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MkAgePrior.R
\name{GetLLRAge}
\alias{GetLLRAge}
\title{LLR-age from Ageprior Matrix}
\usage{
GetLLRAge(AgePriorExtra, agedif, patmat)
}
\arguments{
\item{AgePriorExtra}{matrix in \code{\link{sequoia}} output}

\item{agedif}{vector with age differences, in whole numbers. Must occur in
rownames of \code{AgePriorExtra}.}

\item{patmat}{numeric vector; choose maternal (1), paternal (2) relatives, or
for each relationship the most-likely alternative (3).}
}
\value{
A matrix with \code{nrow} equal to the length of \code{agedif}, and 7
  columns: PO-FS-HS-GP-FA-HA-U.
}
\description{
Get log10-likelihood ratios for a specific age difference from
  matrix \code{AgePriorExtra}.
}
\examples{
data(SeqOUT_griffin, package="sequoia")
PairsG <- data.frame(ID1="i122_2007_M",
                     ID2 = c("i124_2007_M", "i042_2003_F", "i083_2005_M"),
                     AgeDif = c(0,4,2))
cbind(PairsG,
      GetLLRAge(SeqOUT_griffin$AgePriorExtra,
                agedif = PairsG$AgeDif, patmat=rep(2,3)))

}
