% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MkAgePrior.R
\name{MakeAgeprior}
\alias{MakeAgeprior}
\title{Age priors}
\usage{
MakeAgeprior(UseParents = FALSE, nAgeClasses = 0, Parents = NULL,
  LifeHistData = NULL)
}
\arguments{
\item{UseParents}{use the age distribution of assigned parents. Otherwise,
equal probabilities across all age differences are assumed.}

\item{nAgeClasses}{number of age classes; age prior matrix will have
nAgeClasses + 1 rows.}

\item{Parents}{dataframe with scaffold pedigree of assigned parents;
columns ID - Dam - Sire}

\item{LifeHistData}{dataframe with 3 columns:
\itemize{
\item{ID: }{max. 30 characters long,}
\item{Sex: }{1 = females, 2 = males, other numbers = unkown,}
\item{Birth Year: }{(or hatching year) Zero and negative numbers are
  interpreted as missing values.}}}
}
\value{
A matrix with the probability ratio of two individuals being a
  certain type of relative versus being a random draw, conditional on the
  (absolute) age difference between those individuals.

  One row per absolute age difference (0 - nAgeClasses), and one column for
  each relationship type, with abbreviations:
     \item{MS}{Maternal siblings}
     \item{PS}{Paternal siblings}
     \item{MGM}{Maternal grandmother}
     \item{PGF}{Paternal grandfather}
     \item{MGF}{Maternal grandfathers and paternal grandmothers}
     \item{UA}{Avuncular}
     \item{M}{Mothers}
     \item{P}{Fathers}
}
\description{
Calculate age-based prior probabilities for various categories of pairwise
relatives.
}
\details{
if UseParents = TRUE, Retrieve age distributions of maternal & paternal
parents, siblings and grandparents from assigned parents, to use as input
for sibship clustering and grandparent assignment.
If the lifehistory file indicates a single age class, \eqn{MS = PS = 1} and
 \eqn{MGM = PGF = MGF = UA = 0}.
}

