% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMakefile.R
\name{addJob}
\alias{addJob}
\title{Add a job to a workflow}
\usage{
addJob(wf, job)
}
\arguments{
\item{wf}{a variable of workflow class}

\item{job}{a variable of job class}
}
\description{
Add a job to a workflow
}
\examples{
j1 <- newJob('id1', 'cmd out1', 'out1')
j2 <- newJob('id2', 'cmd out2', 'out2', depend = 'out1')
w <- newWorkflow("wf")
w <- addJob(w, j1)
w <- addJob(w, j2)

outFile <- file.path(tempdir(), "Makefile")
writeWorkflow(w, outFile)
cat('Outputted Makefile file are in the temp directory:', outFile, '\\n')
}
