\name{nhppSpike}
\alias{nhppSpike}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Spike rates of NHPP
}
\description{
Randomly spike the smoothed control rate of an NHPP according to the parameters.
}
\usage{
nhppSpike(smoothRates, nSpike = 25, cptLenR = 4, cptLenMean = 10, minGain = 1.5, maxGain = 10, minLoss = 0.01, maxLoss = 0.5, pGain = 0.6)
}
\arguments{
  \item{smoothRates}{
The smoothed rate estimate of the control process
}
  \item{nSpike}{
Number of signal spikes
}
  \item{cptLenR}{
Parameter for signal width (parameter R of negative binomial)
}
  \item{cptLenMean}{
Parameter for signal width (mean width)
}
  \item{minGain}{
Minimal Gain relative CN
}
  \item{maxGain}{
Maximal Gain relative CN
}
  \item{minLoss}{
Minimal Loss relative CN
}
  \item{maxLoss}{
Maximal Loss relative CN
}
  \item{pGain}{
Proportion of signal regions that are CN gain.
}
}
\details{
The signal width is randomly generated by negative binomial distribution with the two parameters given. The signal strength are uniformly drawn between the two limits.
}
\value{
  \item{spikeMat }{A matrix containing the actual signal spike information}
  \item{caseRates }{The rate of the case PP to be simulated after signal spike}
}
\author{
Jeremy J. Shen
}

\seealso{
\code{\link{nhppSimulate}}
}