% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stringAlgebra.R
\name{prep_deref}
\alias{prep_deref}
\title{Substitute language elements by one-expand_expr.}
\usage{
prep_deref(lexpr, env = parent.frame())
}
\arguments{
\item{lexpr}{language item (captured by substitute())}

\item{env}{environment to look in}
}
\value{
R language element with dequotes and derefs
}
\description{
Substitute language elements by one-expand_expr.
}
\examples{

resCol1 <- "Sepal_Long"
ratio <- 2
compCol1 <- "Sepal.Width"
f <- function(expr, env = parent.frame()) {
   mt <- substitute(expr)
   deparse(prep_deref(mt, env))
}
expr <- f("Sepal.Length" >= ratio * compCol1)
print(expr)
iris \%.>\%
   mutate_se(., resCol1 := expr) \%.>\%
   head(.)

}
