% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures_measures_xyz.R
\name{measures_global}
\alias{measures_global}
\title{Merge sentiment measures into multiple weighted global sentiment indices}
\usage{
measures_global(sentomeasures, lexicons = 1, features = 1, time = 1)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{lexicons}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$lexicons)}, in the same order.
By default set to 1, which means equally weighted.}

\item{features}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$features)}, in the same order.
By default set to 1, which means equally weighted.}

\item{time}{a \code{numeric} vector of weights, of size \code{length(sentomeasures$time)}, in the same order. By default
set to 1, which means equally weighted.}
}
\value{
A \code{data.table} with the different types of weighted global sentiment measures, named \code{"globLex"},
\code{"globFeat"}, \code{"globTime"} and \code{"global"}, with \code{"date"} as the first column. The last measure is an average
of the the three other measures.
}
\description{
Merges all sentiment measures into a weighted global textual sentiment measure for each of the
\code{lexicons}, \code{features}, and \code{time} dimensions.
}
\details{
In contrast to other \code{measures_xyz} functions, this particular function returns no new \code{sentomeasures}
object. The global sentiment measures as outputted can easily be added to regressions as an additional
variable using the \code{x} argument in the \code{\link{sento_model}} function (omitting the \code{"date"} column). The
measures are constructed from weights that indicate the importance (and sign) along each component from the \code{lexicons},
\code{features}, and \code{time} dimensions. There is no condition in terms of allowed weights. For example, the global index
based on the supplied lexicon weights (\code{"globLex"}) is obtained first by multiplying every sentiment measure with
its corresponding weight (meaning, the weight given to the lexicon the sentiment is computed with), then by taking
the average per date.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- sento_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# merge into one global sentiment measure, with specified weighting for lexicons and features
global <- measures_global(sentomeasures,
                          lexicons = c(0.40, 0.60),
                          features = c(0.10, -0.20, 0.30, -1),
                          time = 1)

}
\seealso{
\code{\link{sento_model}}
}
\author{
Samuel Borms
}
