% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sobol.R
\name{plot.sensobol}
\alias{plot.sensobol}
\title{Visualization of first, total, second, third and fourth-order Sobol' indices.}
\usage{
\method{plot}{sensobol}(x, order = "first", dummy = NULL, ...)
}
\arguments{
\item{x}{The output of \code{\link{sobol_indices}}.}

\item{order}{If \code{order = "first"}, it plots first and total-order effects.
If \code{order = "second"}, it plots second-order effects. If \code{order = "third"}, it plots
third-order effects. If \code{order = "fourth"}, it plots
third-order effects. Default is \code{order = "first"}.}

\item{dummy}{The output of \code{\link{sobol_dummy}}. Default is NULL.}

\item{...}{Other graphical parameters to plot.}
}
\value{
A \code{ggplot} object.
}
\description{
It plots first, total, second, third and fourth-order Sobol' indices.
}
\examples{
# Define settings
N <- 1000; params <- paste("X", 1:3, sep = ""); R <- 10

# Create sample matrix
mat <- sobol_matrices(N = N, params = params)

# Compute Ishigami function
Y <- ishigami_Fun(mat)

# Compute and bootstrap Sobol' indices
ind <- sobol_indices(Y = Y, N = N, params = params, boot = TRUE, R = R)

# Plot Sobol' indices
plot(ind)
}
