% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_tile_suffix.R
\name{add_tile_suffix}
\alias{add_tile_suffix}
\alias{remove_tile_suffix}
\alias{extract_tile_suffix}
\title{Add/remove suffixes for split tiles}
\usage{
add_tile_suffix(paths, suffix)

remove_tile_suffix(paths)

extract_tile_suffix(paths)
}
\arguments{
\item{paths}{Paths of the input tiled products}

\item{suffix}{Character (1-length): if provided, the specified suffix is
appended to the tile ID of each path;
if not provided (default), a sequential suffix is appended only to the tile
ID of the duplicated paths.}
}
\value{
The input paths with/without the tile suffix.
}
\description{
\code{add_tile_suffix()} adds specific suffixes to tile IDs
in order to distinguish tiled filenames referring to different original
SAFE products.

\code{remove_tile_suffix()} removes existing suffixes from tile IDs.

\code{extract_tile_suffix()} extracts suffixes from input paths.
}
\details{
In some sporadic cases, a tiled Sentinel-2 image is split in two
SAFE products (see e.g. products
\href{https://storage.cloud.google.com/gcp-public-data-sentinel-2/tiles/32/T/NL/S2A_MSIL1C_20200408T101021_N0209_R022_T32TNL_20200408T153254.SAFE/GRANULE/L1C_T32TNL_A025044_20200408T101022/QI_DATA/T32TNL_20200408T101021_PVI.jp2}{\code{S2A_MSIL1C_20200408T101021_N0209_R022_T32TNL_20200408T153254}} and
\href{https://storage.cloud.google.com/gcp-public-data-sentinel-2/tiles/32/T/NL/S2A_MSIL1C_20200408T101021_N0209_R022_T32TNL_20200408T171107.SAFE/GRANULE/L1C_T32TNL_A025044_20200408T101923/QI_DATA/T32TNL_20200408T101021_PVI.jp2}{\code{S2A_MSIL1C_20200408T101021_N0209_R022_T32TNL_20200408T171107}}).
This split, probably a consequence of the division of the whole orbit image,
creates ambiguity in the association among SAFE images and \code{sen2r} products,
since the sen2r naming convention is not sufficient to manage them as separate
products.
So, in the definition of the filenames of intermediate tiled products
(output of \code{s2_translate()}) it is necessary to add a suffix to be able to
manage them separately and then merge them in \code{s2_merge()}.
A lowercase letter ("a" and "b", but potentially "a" to "z") is used.
Functions \code{add_tile_suffix()} and \code{remove_tile_suffix()} are used in the
\code{sen2r()} main code as a workaround.
}
\note{
License: GPL 3.0
}
\examples{
safe_names <- c(
  "S2A_MSIL2A_20200408T101021_N0214_R022_T32TNK_20200408T175711.SAFE",
  "S2A_MSIL2A_20200408T101021_N0214_R022_T32TNL_20200408T175711.SAFE",
  "S2A_MSIL2A_20200408T101021_N0214_R022_T32TNL_20200408T161405.SAFE"
)
prod_names <- safe_shortname(safe_names, ext = ".tif", allow_duplicated = TRUE)
( prod_names_univoc <- sen2r:::add_tile_suffix(prod_names) )
( prod_names_custom <- sen2r:::add_tile_suffix(prod_names, "a") )
sen2r:::remove_tile_suffix(prod_names_univoc)
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2020) \email{luigi@ranghetti.info}
}
