% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{seminr_theme_create}
\alias{seminr_theme_create}
\title{Create a theme for a seminr graph visualization}
\usage{
seminr_theme_create(
  plot.title.fontsize = 24,
  plot.title.fontcolor = "black",
  plot.fontname = "helvetica",
  plot.splines = TRUE,
  plot.rounding = 3,
  plot.adj = FALSE,
  plot.specialcharacters = TRUE,
  plot.randomizedweights = FALSE,
  plot.bgcolor = "transparent",
  mm.node.color = "dimgrey",
  mm.node.fill = "white",
  mm.node.label.fontsize = 8,
  mm.node.label.fontcolor = "black",
  mm.edge.positive.color = "dimgrey",
  mm.edge.negative.color = "dimgrey",
  mm.edge.positive.style = "solid",
  mm.edge.negative.style = "dashed",
  mm.edge.label.fontsize = 7,
  mm.edge.label.fontcolor = "black",
  mm.edge.label.show = TRUE,
  mm.edge.minlen = 1,
  mm.edge.width_multiplier = 3,
  mm.edge.width_offset = 0.5,
  mm.edge.use_outer_weights = TRUE,
  mm.edge.boot.show_t_value = FALSE,
  mm.edge.boot.show_p_value = FALSE,
  mm.edge.boot.show_p_stars = TRUE,
  mm.edge.boot.show_ci = FALSE,
  mm.edge.boot.template = edge_template_minimal(),
  sm.node.color = "black",
  sm.node.fill = "white",
  sm.node.label.fontsize = 12,
  sm.node.label.fontcolor = "black",
  sm.node.endo.template = node_endo_template_default(),
  sm.node.exo.template = node_exo_template_default(),
  sm.edge.boot.show_t_value = FALSE,
  sm.edge.boot.show_p_value = FALSE,
  sm.edge.boot.show_p_stars = TRUE,
  sm.edge.boot.show_ci = TRUE,
  sm.edge.boot.template = edge_template_default(),
  sm.edge.positive.color = "black",
  sm.edge.negative.color = "black",
  sm.edge.positive.style = "solid",
  sm.edge.negative.style = "dashed",
  sm.edge.label.fontsize = 9,
  sm.edge.label.fontcolor = "black",
  sm.edge.label.show = TRUE,
  sm.edge.label.all_betas = TRUE,
  sm.edge.minlen = NA_integer_,
  sm.edge.width_offset = 0.5,
  sm.edge.width_multiplier = 5,
  construct.reflective.shape = "ellipse",
  construct.reflective.arrow = "backward",
  construct.reflective.use_weights = FALSE,
  construct.compositeA.shape = "hexagon",
  construct.compositeA.arrow = "backward",
  construct.compositeA.use_weights = FALSE,
  construct.compositeB.shape = "hexagon",
  construct.compositeB.arrow = "forward",
  construct.compositeB.use_weights = TRUE,
  manifest.reflective.shape = "box",
  manifest.compositeA.shape = "box",
  manifest.compositeB.shape = "box",
  ...
)
}
\arguments{
\item{plot.title.fontsize}{Font size of the title.}

\item{plot.title.fontcolor}{Fontcolor of the title of the plot.}

\item{plot.fontname}{Font to be used throughout the plot.}

\item{plot.splines}{Whether or not to use splines as edges (default = TRUE).}

\item{plot.rounding}{The amount of decimals to keep for rounding (default = 3).}

\item{plot.adj}{TRUE or FALSE (default). Whether or not to use adjusted r^2 in constructs.}

\item{plot.specialcharacters}{Whether or not to use greek UTF-8 symbols in plots.}

\item{plot.randomizedweights}{TRUE or FALSE (default), decides whether to add.
minimal random weights to the measurement model. Can help with determinism in plot outcomes.}

\item{plot.bgcolor}{The background color of the plot (default = "transparent").}

\item{mm.node.color}{Color of the measurement model nodes.}

\item{mm.node.fill}{Fill of the measurement model nodes.}

\item{mm.node.label.fontsize}{Font size of the measurement model node labels.}

\item{mm.node.label.fontcolor}{Color of the measurement model node labels.}

\item{mm.edge.positive.color}{Color of the measurement model edges, when values are positive.}

\item{mm.edge.negative.color}{Color of the measurement model edges, when values are negative.}

\item{mm.edge.positive.style}{Style of the measurement model edges, when values are positive.}

\item{mm.edge.negative.style}{Style of the measurement model edges, when values are negative.}

\item{mm.edge.label.fontsize}{Font size of the measurement model edge labels.}

\item{mm.edge.label.fontcolor}{Font color of the measurement model edge labels.}

\item{mm.edge.label.show}{Whether or not to show measurement model edge labels.}

\item{mm.edge.minlen}{Minimum length of the measurement model edges.}

\item{mm.edge.width_multiplier}{The multiplier for measurement model edge penwidth (default = 3).}

\item{mm.edge.width_offset}{The minimal width of an edge of the measurement model (default = 0.5).}

\item{mm.edge.use_outer_weights}{Whether or not to use outer weights as edge labels in the measurement model.}

\item{mm.edge.boot.show_t_value}{Should boot-strapped loadings/weights show a t-value}

\item{mm.edge.boot.show_p_value}{Should boot-strapped loadings/weights show a p-value}

\item{mm.edge.boot.show_p_stars}{Should boot-strapped loadings/weights show significance stars}

\item{mm.edge.boot.show_ci}{Should boot-strapped loadings/weights show a 95 percent confidence interval}

\item{mm.edge.boot.template}{A template string for HTML formatting of edges for loadings/weights}

\item{sm.node.color}{Color of the structural model nodes.}

\item{sm.node.fill}{Fill of the structural model nodes.}

\item{sm.node.label.fontsize}{Font size of the structural model node labels.}

\item{sm.node.label.fontcolor}{Font color of the structural model node labels.}

\item{sm.node.endo.template}{A template string for the nodes of endogenous constructs}

\item{sm.node.exo.template}{A template string for the nodes of exogenous constructs}

\item{sm.edge.boot.show_t_value}{Should boot-strapped path coefficients show a t-value}

\item{sm.edge.boot.show_p_value}{Should boot-strapped path coefficients show a p-value}

\item{sm.edge.boot.show_p_stars}{Should boot-strapped path coefficients show significance stars}

\item{sm.edge.boot.show_ci}{Should boot-strapped path coefficients show a 95 percent confidence interval}

\item{sm.edge.boot.template}{A template string for HTML formatting of edges}

\item{sm.edge.positive.color}{Color of the structural model edges, when values are positive.}

\item{sm.edge.negative.color}{Color of the structural model edges, when values are negative.}

\item{sm.edge.positive.style}{Style of the structural model edges, when values are positive.}

\item{sm.edge.negative.style}{Style of the structural model edges, when values are negative.}

\item{sm.edge.label.fontsize}{Font size of the structural model edge labels.}

\item{sm.edge.label.fontcolor}{Font color of the structural model edge labels.}

\item{sm.edge.label.show}{Whether or not to show edge labels on structural model edges.}

\item{sm.edge.label.all_betas}{Whether to label both endogenous and exogenous paths with a beta (default = TRUE).}

\item{sm.edge.minlen}{Minimum length of the structural model edges.}

\item{sm.edge.width_offset}{The minimal width of an edge of the structural model (default = 0.5).}

\item{sm.edge.width_multiplier}{The multiplier for structural model edges (default = 5).}

\item{construct.reflective.shape}{Dot shape of reflective constructs}

\item{construct.reflective.arrow}{Direction of the arrow for reflective constructs. Can be forward, backward (default), or none.}

\item{construct.reflective.use_weights}{Should measurements from reflective constructs show weights (TRUE) or loadings (FALSE: default).}

\item{construct.compositeA.shape}{Dot shape of composite constructs using correlation weights}

\item{construct.compositeA.arrow}{Direction of the arrow for constructs using correlation weight (default: backward)}

\item{construct.compositeA.use_weights}{Should measurements from constructs using correlation weights show weights (TRUE) or loadings (FALSE: default).}

\item{construct.compositeB.shape}{Dot shape of composite constructs using regression weights}

\item{construct.compositeB.arrow}{Direction of the arrow for constructs using regression weights (default: forward)}

\item{construct.compositeB.use_weights}{Should measurements from constructs using regression weights show weights (TRUE: default) or loadings (FALSE).}

\item{manifest.reflective.shape}{Dot shape of manifest variables of reflective constructs}

\item{manifest.compositeA.shape}{Dot shape of manifest variables of composite constructs using correlation weights}

\item{manifest.compositeB.shape}{Dot shape of manifest variables of composite constructs using regression weights}

\item{...}{additional parameters (unused)}
}
\value{
A \code{seminr.theme} object that can be supplied to \code{\link{dot_graph}}
}
\description{
All customizable options are parameters of this function. See the details all the way down for more information.
}
\details{
You can use the auto-complete feature of your editor to help you find the right parameter.

General settings start with plot.*

Measurement model settings start with mm.*

Structural model settings start with sm.*

Setting the shape of manifest or construct variables depending on their estimation type
can be found under manifest.* and construct.*
}
