% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{has_text}
\alias{has_text}
\alias{has_exact_text}
\title{Does an element contain a pattern?}
\usage{
has_text(x, text)

has_exact_text(x, text)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{text}{A string, used to test the element's inner text.}
}
\value{
A boolean value: TRUE or FALSE.
}
\description{
\code{has_text()} checks that an element's inner text contains a string, while
\code{has_exact_text()} checks that the inner text \emph{only} contains the string.
Both functions throw an error if the element does not exist in the DOM.
}
\details{
These functions do not implement a retry mechanism, and only test a condition
once. Use \code{\link[=elem_expect]{elem_expect()}} or \code{\link[=elem_wait_until]{elem_wait_until()}} to use these conditions in
tests.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<p>Example text</p>
<p class='empty'></p>
"

session <- minimal_selenider_session(html)

has_text(s("p"), "Example") # TRUE

has_exact_text(s("p"), "Example") # FALSE

has_exact_text(s("p"), "Example text") # TRUE

# has_exact_text() is useful for checking when there is no text,
# since has_text("") will always be TRUE.
has_exact_text(s(".empty"), "")
\dontshow{\}) # examplesIf}
}
\seealso{
Other conditions: 
\code{\link{has_attr}()},
\code{\link{has_css_property}()},
\code{\link{has_length}()},
\code{\link{has_name}()},
\code{\link{is_enabled}()},
\code{\link{is_present}()},
\code{\link{is_visible}()}
}
\concept{conditions}
