% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{elem_text}
\alias{elem_text}
\title{Get the text inside an element}
\usage{
elem_text(x, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object.}

\item{timeout}{The time to wait for \code{x} to exist.}
}
\value{
A string.
}
\description{
Get the inner text of a \code{selenider_element} object.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<p>Example text</p>
"

session <- minimal_selenider_session(html)

s("p") |>
  elem_text()

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other properties: 
\code{\link{elem_attr}()},
\code{\link{elem_css_property}()},
\code{\link{elem_name}()},
\code{\link{elem_size}()}
}
\concept{properties}
