% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{db_functions}
\alias{db_functions}
\alias{.db_list}
\alias{.db_set}
\alias{.db_del}
\alias{.db_get}
\alias{sm_list_metrics}
\alias{sm_new_metric}
\alias{sm_reg_metric}
\alias{sm_unreg_metric}
\alias{sm_desc_metric}
\title{Database of metrics functions}
\usage{
.db_list()

.db_set(key, value)

.db_del(key)

.db_get(key)

sm_list_metrics()

sm_new_metric(
  fn,
  fn_subset,
  name = "",
  optimal = 0,
  description = "",
  reference = ""
)

sm_reg_metric(metric_id, entry)

sm_unreg_metric(metric_id)

sm_desc_metric(metric_id)
}
\arguments{
\item{fn}{A \code{function} that receives a \code{segmetric} object and
returns the metric values.}

\item{fn_subset}{A \code{function} that returns a \code{subset}.}

\item{name}{A \code{character} containing the metric name
(Defaults to \code{""}).}

\item{description}{A \code{character} containing a description of the metric
(Defaults to \code{""}).}

\item{reference}{A \code{character} with the reference to a scientific
literature describing the metric.}

\item{metric_id}{A \code{character} value containing a unique metric
identification.}

\item{entry}{A \code{metric_entry} object returned by \code{new_metric()}
function.}
}
\value{
\itemize{
\item \code{sm_list_metrics()}: Return \code{character} vector with supported metrics.
\item \code{sm_new_metric()}: Return a \code{metric_entry} object containing the
metric function (\code{fn}), name (\code{name}), description (\code{description}), and
reference (\code{reference}).
\item \code{sm_reg_metric()}, \code{sm_unreg_metric()}: No return value, called to
(un)register a metric.
\item \code{sm_desc_metric()}: No return value, called to print a metric description.
}
}
\description{
These functions are used to register new metrics in the \code{segmetric}
database.
\itemize{
\item \code{sm_list_metrics()}: List all registered metrics.
\item \code{sm_new_metric()}: Create a new metric entry to be registered in
the database.
\item \code{sm_reg_metric()}: Register a new metric in the database.
\item \code{sm_unreg_metric()}: Remove a metric entry from the database.
\item \code{sm_desc_metric()}: Describe a metric registered from the database.
}
}
\examples{
sm_reg_metric(
    metric_id = "Example",
    entry = sm_new_metric(
        fn = function(m) {
            sm_area(sm_ytilde(m)) / 
                sm_area(sm_ref(m), order = sm_ytilde(m))
        },
        fn_subset = sm_ytilde,
        name = "Metric name example",
        description = paste("Values range from A to B.",
                            "Optimal value is C"),
        reference = "Author (Year)"
    ))

sm_desc_metric("Example")
sm_list_metrics()

}
\keyword{internal}
