% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_segment.R
\name{base_segment}
\alias{base_segment}
\title{Base arguments for segment function}
\usage{
base_segment(data, likelihood, max_segments, allow_parallel)
}
\arguments{
\item{data}{matrix for which to find the change points}

\item{likelihood}{a function receives the segment matrix as argument
and returns a likelihood estimation. This function is used to calculate the
change points that maximize the total likelihood. Depending on the algorithm
being used, this function is likely to be executed many times, in which
case it's also likely to be the bottleneck of the function execution, so
it's advised that this function should have fast implementation.}

\item{max_segments}{an integer that defines the maximum amount of segments to
split the data into.}

\item{allow_parallel}{allows parallel execution to take place using the
registered cluster. Assumes a cluster is registered with the \code{foreach}
package. Defaults to TRUE.}
}
\value{
a list of type \code{segmentr}, which has the two attributes:
\itemize{
\item \code{changepoints}: a vector with the first index of each identified change point
\item \code{segments}: a list of vectors, in which each vector corresponds to the indices
that identifies a segment.
}
}
\description{
Describe base arguments for segment function
}
\keyword{internal}
