% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_arrange.R
\name{multicurve}
\alias{multicurve}
\title{Merge multiple curves into a single graph}
\usage{
multicurve(
  plots,
  theme = theme_classic(),
  legend.title = NULL,
  legend.position = "top",
  trat = NA,
  gray = FALSE,
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)")
)
}
\arguments{
\item{plots}{list with objects of type LM_model, BC_model, CD_model, LL_model or normal_model}

\item{theme}{ggplot2 theme (\emph{default} is theme_classi())}

\item{legend.title}{caption title}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{trat}{name of the curves}

\item{gray}{gray scale (\emph{default} is FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}
}
\value{
The function returns a graph joining the outputs of the functions LM_model, LL_model, BC_model, CD_model, loess_model, normal_model, piecewise_model and N_model
}
\description{
Merge multiple curves into a single graph
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)
a=LM_model(trat,resp)
b=LL_model(trat,resp,npar = "LL.3")
c=BC_model(trat,resp, npar = "BC.4")
d=CD_model(trat,resp, npar = "CRS.4")
multicurve(list(a,b,c,d))
}
\author{
Gabriel Danilo Shimizu
}
