% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals}
\alias{check_residuals}
\title{Check model used in OCSB test}
\usage{
check_residuals(x, plot = F)
}
\arguments{
\item{x}{results of ocsb test}

\item{plot}{boolean, should barplot be printed?}
}
\description{
Test the residuals of the model used for the OCSB test for serial correlation.
}
\details{
The residuals of the model used for the OCSB test should ideally be white noise. Here the Ljung-Box statistic is calculated and shown for all lags up to 2 times the frequency of the series. Be aware that the Ljung-Box statistic is a 'cumulative test'. For instance, the p-value of the Ljung-Box statistic for lag 3 is based on the null hypothesis, that the autocorrelations of the first three lags are jointly zero.
}
\examples{
teststat <- ocsb(ts(rnorm(100, 10,10), frequency=12), nrun=100)
check_residuals(teststat)
}
\references{
Box, G. and G. Jenkins (1970). Time Series Analysis: Forecasting and Control. San Francisco: Holden-Day.

Osborn D.R., Chui A.P.L., Smith J., and Birchenhall C.R. (1988). Seasonality and the order of integration for consumption, Oxford Bulletin of Economics and Statistics 50(4):361-377.
}
\author{
Daniel Ollech
}
