% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsample.r
\name{subsample}
\alias{subsample}
\title{Function used to linearly subsample data at new depth values}
\usage{
subsample(data, old_depth, new_depth, AV = FALSE, plot = FALSE)
}
\arguments{
\item{data}{A vector of data to be interpolated}

\item{old_depth}{A vector containing the depth values belonging to \code{data}}

\item{new_depth}{A vector containing depth values at which the \code{data}
should be interpolated.}

\item{AV}{Should the subsampling take into account the mean value within the
sample interval? \code{TRUE/FALSE} If \code{FALSE}, the interpolated value
corresponding to the exact position is used instead of the mean of the interval}

\item{plot}{Should the result be plotted? \code{TRUE/FALSE}}
}
\value{
A vector listing the values interpolated from \code{data} at the
positions of \code{new_depth}
}
\description{
Function used to linearly subsample data at new depth values
}
\examples{
# Create test data (= ideal case)
# Set boundary conditions
Td <- seq(1, 12 * 365, 1) # Create timeline of 12 years in days
Ty <- Td / 365 # Convert to years
MAT <- 20 # Set mean annual temperature
Amp <- 10 # Set seasonal amplitude
Sext <- 2 * Amp # Calculate extent of seasonal variability
TSD <- 1.5 # Set the degree of random nonâ€“seasonal noise on the SST curve
# ("weather")
SST <- rnorm(length(Ty), MAT + Amp * sin(2 * pi * Ty), TSD) # Create virtual
# daily SST data
GR <- rep(10 / 365, length(Ty)) # Set growth rate to 10 mm/yr and create daily
# GR vector
SR <- 0.75 # Set sampling resolution to 0.75 mm
# Create vector for all samples along entire shell length by applying constant
# sampling resolution
D <- seq(SR, sum(GR), SR)
D_cum <- cumsum(GR) # Create cumulative depth vector for all values
new_data <- subsample(SST, D_cum, D, AV = TRUE, plot = FALSE) # Interpolate
# SST values at the positions of D while calculating sample averages
}
