% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_import.R
\name{hier_import}
\alias{hier_import}
\title{Imports a nested data structure}
\usage{
hier_import(inp, from = "json", root = NULL, keep_order = FALSE)
}
\arguments{
\item{inp}{an object that should be imported. Argument \code{from} specifies
the input format.}

\item{from}{(character) from which format should be imported.
Possible choices are:
\itemize{
\item \code{"json"}: a json-encoded string as created using
\code{\link[=hier_convert]{hier_convert()}} with argument \verb{as = "json")}
\item \code{"df"}: a \code{data.frame} in \verb{@;level}-format or an input created
with \code{\link[=hier_convert]{hier_convert()}} with argument \verb{as = "df")}
\item \code{"dt"}: a \code{data.frame} in \verb{@;level}-format or an input created
with \code{\link[=hier_convert]{hier_convert()}} with argument \verb{as = "dt")}
\item \code{"argus"}: a json-encoded string as created using
\code{\link[=hier_convert]{hier_convert()}} with argument \verb{as = "argus")}
\item \code{"code"}: a json-encoded string as created using
\code{\link[=hier_convert]{hier_convert()}} with argument \verb{as = "code")}
\item \code{"hrc"}: text-files in tau-argus hrc-format
\item \code{"sdc"}: a json-encoded string as created using
\code{\link[=hier_convert]{hier_convert()}} with argument \verb{as = "sdc")}
}}

\item{root}{optional name of overall total}

\item{keep_order}{if \code{TRUE}, the original order of nodes
is kept from the input object; if \code{FALSE}, the nodes are
sorted lexicographically within each leaf.}
}
\value{
a (nested) hierarchy
}
\description{
This function creates a nested sdc hierarchy from various
input structures.
}
\examples{
h <- hier_create(root = "Total", nodes = LETTERS[1:2])
h <- hier_add(h, root = "A", nodes = c("a1", "a2"))
h <- hier_add(h, root = "B", nodes = c("b1", "b2"))
h <- hier_add(h, root = "b1", nodes = "b1a")
hier_display(h)

df <- hier_convert(h, as = "df")
hier_display(df)

h2 <- hier_import(df, from = "df")
hier_display(h2)

# check order
df <- data.frame(
  level = c("@", "@@", "@@"),
  name = c("T", "m", "f")
)
hier_display(hier_import(df, from = "df")) # automatically sorted (T, f, m)
hier_display(hier_import(df, from = "df", keep_order = TRUE)) # original order (T, m, f)
}
\seealso{
\code{\link[=hier_to_tree]{hier_to_tree()}}
}
