% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_theta_gbp.r
\name{get_theta_gbp}
\alias{get_theta_gbp}
\title{Find Scale Parameter for Generalised Beta Prime (Half-Cauchy) Hyperprior}
\usage{
get_theta_gbp(alpha = 0.01, method = "integrate", Z, c = 3,
  eps = .Machine$double.eps, Kinv)
}
\arguments{
\item{alpha}{denotes the 1-\eqn{\alpha} level.}

\item{method}{with \code{integrate} as default.
Currently no further method implemented.}

\item{Z}{the design matrix.}

\item{c}{denotes the expected range of the function.}

\item{eps}{denotes the error tolerance of the result, default is \code{.Machine$double.eps}.}

\item{Kinv}{the generalised inverse of K.}
}
\value{
an object of class \code{list} with values from \code{\link{uniroot}}.
}
\description{
This function implements a optimisation routine that computes the scale parameter \eqn{\theta}
of the gamma prior for \eqn{\tau^2} (corresponding to a half cauchy for \eqn{\tau}) 
for a given design matrix and prior precision matrix
such that approximately \eqn{P(|f(x_{k}|\le c,k=1,\ldots,p)\ge 1-\alpha}
}
\examples{
set.seed(123)
require(MASS)
# prior precision matrix (second order differences) 
# of a spline of degree l=3 and with m=20 inner knots
# yielding dim(K)=m+l-1=22
K <- t(diff(diag(22), differences=2))\%*\%diff(diag(22), differences=2)
# generalised inverse of K
Kinv <- ginv(K)
# covariate x
x <- runif(1)
Z <- matrix(DesignM(x)$Z_B,nrow=1)
theta <- get_theta_gbp(alpha = 0.01, method = "integrate", Z = Z, 
                            c = 3, eps = .Machine$double.eps, Kinv = Kinv)$root

\donttest{

set.seed(91179)
library(BayesX)
library(MASS)
# prior precision matrix to zambia data set
K <- read.gra(system.file("examples/zambia.gra", package="sdPrior"))
# generalised inverse of K
Kinv <- ginv(K)

# read data
dat <- read.table(system.file("examples/zambia_height92.raw", package="sdPrior"), header = TRUE)

# design matrix for spatial component
Z <- t(sapply(dat$district, FUN=function(x){1*(x==rownames(K))}))

# get scale parameter
theta <- get_theta_gbp(alpha = 0.01, method = "integrate", Z = Z, 
                            c = 3, eps = .Machine$double.eps, Kinv = Kinv)$root
} 

}
\references{
Nadja Klein and Thomas Kneib (2015). Scale-Dependent Priors for Variance Parameters in Structured Additive Distributional Regression. 
\emph{Working Paper}.

Andrew Gelman (2006). Prior Distributions for Variance Parameters in Hierarchical Models. 
\emph{Bayesian Analysis}, \bold{1}(3), 515--533.
}
\author{
Nadja Klein
}
