% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/denoise.R
\name{correct}
\alias{correct}
\title{Correct data by setting all latent factors to their median values and reversing the regression model}
\usage{
correct(
  x,
  data = "y",
  cell_attr = x$cell_attr,
  do_round = TRUE,
  do_pos = TRUE,
  verbosity = 2,
  verbose = TRUE,
  show_progress = TRUE
)
}
\arguments{
\item{x}{A list that provides model parameters and optionally meta data; use output of vst function}

\item{data}{The name of the entry in x that holds the data}

\item{cell_attr}{Provide cell meta data holding latent data info}

\item{do_round}{Round the result to integers}

\item{do_pos}{Set negative values in the result to zero}

\item{verbosity}{An integer specifying whether to show only messages (1), messages and progress bars (2) or nothing (0) while the function is running; default is 2}

\item{verbose}{Deprecated; use verbosity instead}

\item{show_progress}{Deprecated; use verbosity instead}
}
\value{
Corrected data as UMI counts
}
\description{
Correct data by setting all latent factors to their median values and reversing the regression model
}
\examples{
\donttest{
vst_out <- vst(pbmc, return_cell_attr = TRUE)
umi_corrected <- correct(vst_out)
}

}
