% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_residuals}
\alias{get_residuals}
\title{Return Pearson or deviance residuals of regularized models}
\usage{
get_residuals(vst_out, umi, residual_type = "pearson",
  res_clip_range = c(-sqrt(ncol(umi)), sqrt(ncol(umi))),
  cell_attr = vst_out$cell_attr, bin_size = 256,
  show_progress = TRUE)
}
\arguments{
\item{vst_out}{The output of a vst run}

\item{umi}{The UMI count matrix that will be used}

\item{residual_type}{What type of residuals to return; can be 'pearson' or 'deviance'; default is 'pearson'}

\item{res_clip_range}{Numeric of length two specifying the min and max values the results will be clipped to; default is c(-sqrt(ncol(umi)), sqrt(ncol(umi)))}

\item{cell_attr}{Data frame of cell meta data}

\item{bin_size}{Number of genes to put in each bin (to show progress)}

\item{show_progress}{Whether to print progress bar}
}
\value{
A matrix of residuals
}
\description{
Return Pearson or deviance residuals of regularized models
}
\examples{
\dontrun{
vst_out <- vst(pbmc)
pearson_res <- get_residuals(vst_out, pbmc)
deviance_res <- get_residuals(vst_out, pbmc, residual_type = 'deviance')
}

}
