% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-binary.R,
%   R/class-forecast-nominal.R, R/class-forecast-point.R,
%   R/class-forecast-quantile.R, R/class-forecast-sample.R, R/score.R
\name{score.forecast_binary}
\alias{score.forecast_binary}
\alias{score.forecast_nominal}
\alias{score.forecast_point}
\alias{score.forecast_quantile}
\alias{score.forecast_sample}
\alias{score}
\title{Evaluate forecasts}
\usage{
\method{score}{forecast_binary}(forecast, metrics = get_metrics(forecast), ...)

\method{score}{forecast_nominal}(forecast, metrics = get_metrics(forecast), ...)

\method{score}{forecast_point}(forecast, metrics = get_metrics(forecast), ...)

\method{score}{forecast_quantile}(forecast, metrics = get_metrics(forecast), ...)

\method{score}{forecast_sample}(forecast, metrics = get_metrics(forecast), ...)

score(forecast, metrics, ...)
}
\arguments{
\item{forecast}{A forecast object (a validated data.table with predicted and
observed values).}

\item{metrics}{A named list of scoring functions. Names will be used as
column names in the output. See \code{\link[=get_metrics]{get_metrics()}} for more information on the
default metrics used. See the \emph{Customising metrics} section below for
information on how to pass custom arguments to scoring functions.}

\item{...}{Currently unused. You \emph{cannot} pass additional arguments to scoring
functions via \code{...}. See the \emph{Customising metrics} section below for
details on how to use \code{\link[purrr:partial]{purrr::partial()}} to pass arguments to individual
metrics.}
}
\value{
An object of class \code{scores}. This object is a data.table with
unsummarised scores (one score per forecast) and has an additional attribute
\code{metrics} with the names of the metrics used for scoring. See
\code{\link[=summarise_scores]{summarise_scores()}}) for information on how to summarise
scores.
}
\description{
\code{score()} applies a selection of scoring metrics to a forecast
object.
\code{score()} is a generic that dispatches to different methods depending on the
class of the input data.

See \code{\link[=as_forecast_binary]{as_forecast_binary()}}, \code{\link[=as_forecast_quantile]{as_forecast_quantile()}} etc. for information on
how to create a forecast object.

See \code{\link[=get_forecast_unit]{get_forecast_unit()}} for more information on the concept of a forecast
unit.

For additional help and examples, check out the paper
\href{https://arxiv.org/abs/2205.07090}{Evaluating Forecasts with scoringutils in R}.
}
\details{
\strong{Customising metrics}

If you want to pass arguments to a scoring function, you need change the
scoring function itself via e.g. \code{\link[purrr:partial]{purrr::partial()}} and pass an updated list
of functions with your custom metric to the \code{metrics} argument in \code{score()}.
For example, to use \code{\link[=interval_coverage]{interval_coverage()}} with \code{interval_range = 90}, you
would define a new function, e.g.
\code{interval_coverage_90 <- purrr::partial(interval_coverage, interval_range = 90)}
and pass this new function to \code{metrics} in \code{score()}.

Note that if you want to pass a variable as an argument, you can
unquote it with \verb{!!} to make sure the value is evaluated only once when the
function is created. Consider the following example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{custom_arg <- "foo"
print1 <- purrr::partial(print, x = custom_arg)
print2 <- purrr::partial(print, x = !!custom_arg)

custom_arg <- "bar"
print1() # prints 'bar'
print2() # prints 'foo'
}\if{html}{\out{</div>}}
}
\examples{
library(magrittr) # pipe operator
\dontshow{
  data.table::setDTthreads(2) # restricts number of cores used on CRAN
}

validated <- as_forecast_quantile(example_quantile)
score(validated) \%>\%
  summarise_scores(by = c("model", "target_type"))

# set forecast unit manually (to avoid issues with scoringutils trying to
# determine the forecast unit automatically)
example_quantile \%>\%
  as_forecast_quantile(
    forecast_unit = c(
      "location", "target_end_date", "target_type", "horizon", "model"
    )
  ) \%>\%
  score()

# forecast formats with different metrics
\dontrun{
score(as_forecast_binary(example_binary))
score(as_forecast_quantile(example_quantile))
score(as_forecast_point(example_point))
score(as_forecast_sample(example_sample_discrete))
score(as_forecast_sample(example_sample_continuous))
}
}
\references{
Bosse NI, Gruson H, Cori A, van Leeuwen E, Funk S, Abbott S
(2022) Evaluating Forecasts with scoringutils in R.
\doi{10.48550/arXiv.2205.07090}
}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}
}
\keyword{scoring}
