% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_avail_forecasts}
\alias{plot_avail_forecasts}
\title{Visualise Where Forecasts Are Available}
\usage{
plot_avail_forecasts(
  avail_forecasts,
  y = "model",
  x = "forecast_date",
  make_x_factor = TRUE,
  show_numbers = TRUE
)
}
\arguments{
\item{avail_forecasts}{data.frame with a column called \verb{Number forecasts} as
produced by \code{\link[=avail_forecasts]{avail_forecasts()}}}

\item{y}{character vector of length one that denotes the name of the column
to appear on the y-axis of the plot. Default is "model".}

\item{x}{character vector of length one that denotes the name of the column
to appear on the x-axis of the plot. Default is "forecast_date".}

\item{make_x_factor}{logical (default is TRUE). Whether or not to convert
the variable on the x-axis to a factor. This has an effect e.g. if dates
are shown on the x-axis.}

\item{show_numbers}{logical (default is \code{TRUE}) that indicates whether
or not to show the actual count numbers on the plot}
}
\value{
ggplot object with a plot of interval coverage
}
\description{
Visualise Where Forecasts Are Available
}
\examples{
library(ggplot2)
avail_forecasts <- avail_forecasts(
  example_quantile, by = c("model", "target_type", "target_end_date")
)
plot_avail_forecasts(
 avail_forecasts, x = "target_end_date", show_numbers = FALSE
) +
 facet_wrap("target_type")
}
