% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot_predictions}
\alias{plot_predictions}
\title{Plot Predictions vs True Values}
\usage{
plot_predictions(
  data,
  x = "date",
  add_truth_data = NULL,
  range = c(0, 50, 90),
  facet_formula = NULL,
  facet_wrap_or_grid = "facet_wrap",
  scales = "free_y",
  xlab = x,
  ylab = "True and predicted values"
)
}
\arguments{
\item{data}{a data.frame that follows the same specifications outlined in
\code{\link{eval_forecasts}}. The data.frame needs to have columns called
"true_value", "prediction" and then either a column called sample, or one
called "quantile" or two columns called "range" and "boundary".}

\item{x}{character vector of length one that denotes the name of the variable
on the x-axis. Usually, this will be "date", but it can be anything else.}

\item{add_truth_data}{additional truth data, e.g. past values for which
no predictions are available. This should be a data.frame with a column
called "true_value" and another column corresponding to the x variable selected
for the plot}

\item{range}{numeric vector indicating the interval ranges to plot. If 0 is
included in range, the median prediction will be shown.}

\item{facet_formula}{formula for facetting in ggplot. If this is \code{NULL}
(the default), no facetting will take place}

\item{facet_wrap_or_grid}{Use ggplot2's \code{facet_wrap} or
\code{facet_grid}? Anything other than "facet_wrap" will be interpreted as
\code{facet_grid}. This only takes effect if \code{facet_formula} is not
\code{NULL}}

\item{scales}{scales argument that gets passed down to ggplot. Only necessary
if you make use of facetting. Default is "free_y"}

\item{xlab}{Label for the x-axis. Default is the variable name on the x-axis}

\item{ylab}{Label for the y-axis. Default is "True and predicted values"}
}
\value{
ggplot object with a plot of true vs predicted values
}
\description{
Make a plot of observed and predicted values
}
\examples{
example1 <- scoringutils::continuous_example_data
example2 <- scoringutils::quantile_example_data_long

scoringutils::plot_predictions(example1, x = "id",
                               facet_formula = ~ horizon)
scoringutils::plot_predictions(example2, x = "id",
                               facet_formula = ~ horizon)
}
