% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression_metrics.R
\name{absolute_error}
\alias{absolute_error}
\title{Calculate absolute error regression loss.}
\usage{
absolute_error(y_true, y_pred)
}
\arguments{
\item{y_true}{Ground truth (correct) target values.}

\item{y_pred}{Estimated target values.}
}
\value{
A numeric vector of length equal to \code{max(length(y_true), length(y_pred))}.
}
\description{
Calculate absolute error regression loss.
}
\examples{
absolute_error(1:10, 10:1)
}
\seealso{
Other regression.metrics: \code{\link{absolute_percent_error}},
  \code{\link{explained_variance_score}},
  \code{\link{log_error}},
  \code{\link{mean_absolute_error}},
  \code{\link{mean_absolute_percent_error}},
  \code{\link{mean_absolute_scaled_error}},
  \code{\link{mean_error}},
  \code{\link{mean_percent_error}},
  \code{\link{mean_squared_error}},
  \code{\link{mean_squared_log_error}},
  \code{\link{median_absolute_error}},
  \code{\link{median_absolute_percent_error}},
  \code{\link{median_percent_error}},
  \code{\link{median_squared_error}},
  \code{\link{median_squared_log_error}},
  \code{\link{percent_error}}, \code{\link{r2_score}},
  \code{\link{squared_error}},
  \code{\link{squared_log_error}},
  \code{\link{symmetric_mean_absolute_percent_error}},
  \code{\link{symmetric_median_absolute_percent_error}},
  \code{\link{total_variance_score}},
  \code{\link{unexplained_variance_score}}
}

