% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testquadratic.R
\name{testquadratic}
\alias{testquadratic}
\title{Test Whether a CppAD Tape is a Quadratic Function}
\usage{
testquadratic(tape, xmat = NULL, dynparammat = NULL, verbose = FALSE)
}
\arguments{
\item{tape}{An \code{ADFun} object.}

\item{xmat}{If non-\code{NULL} and \code{dynparamat} non-\code{NULL} then the third-order derivatives at independent variable values of the rows of \code{xmat} and dynamic parameters from the rows of \code{dynparammat} are tested.}

\item{dynparammat}{If non-\code{NULL} and \code{xmat} non-\code{NULL} then the third-order derivatives at independent variable values of the rows of \code{xmat} and dynamic parameters from the rows of \code{dynparammat} are tested.}

\item{verbose}{If TRUE information about the failed tests is printed.}
}
\value{
\code{TRUE} or \code{FALSE}
}
\description{
Uses the \href{https://cppad.readthedocs.io/latest/fun_property.html#parameter}{\code{CppAD} parameter property} and derivatives (via \code{\link[=tapeJacobian]{tapeJacobian()}}) to test whether
the tape is quadratic.
}
\details{
Uses the \code{xtape} and \code{dyntape} values stored in \code{tape} to create new tapes.
A tape of the Hessian is obtained by applying \code{\link[=tapeJacobian]{tapeJacobian()}} twice, and then uses a \href{https://cppad.readthedocs.io/latest/fun_property.html#parameter}{\code{CppAD} property} to test whether the Hessian is constant. A function of quadratic form should have constant Hessian.

If \code{xmat} and \code{dynparammat} are non-\code{NULL} then \code{testquadratic()} also checks the Jacobian of the Hessian at \code{xmat} and \code{dynparammat} values. For quadratic form functions the Jacobian of the Hessian should be zero.
}
\examples{
tapes <- buildsmdtape(
   "sim", "sqrt", "sph",
   ll = "ppi",
   ytape = c(0.2, 0.3, 0.5),
   usertheta = ppi_paramvec(p = 3), 
   bdryw = "minsq",
   acut = 0.1,
   verbose = FALSE)

 testquadratic(tapes$smdtape)
}
\seealso{
Other tape evaluators: 
\code{\link{evaltape}()},
\code{\link{quadratictape_parts}()},
\code{\link{smvalues}()}
}
\concept{tape evaluators}
