% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_adj}
\alias{woebin_adj}
\title{WOE Binning Adjustment}
\usage{
woebin_adj(dt, y, bins, breaks_list = NULL, adj_all_var = TRUE,
  to = "breaks_list", save_as = NULL, ...)
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable.}

\item{bins}{A list of data frames. Binning information generated from \code{woebin}.}

\item{breaks_list}{List of break points, Defaults to NULL. If it is not NULL, variable binning will based on the provided breaks.}

\item{adj_all_var}{Logical, whether to show variables have monotonic woe trends. Defaults to TRUE}

\item{to}{Adjusting bins into breaks_list or bins_list. Defaults to breaks_list.}

\item{save_as}{A string. The file name to save breaks_list. Defaults to None.}

\item{...}{Additional parameters.}
}
\value{
A list of modified break points of each x variables.
}
\description{
\code{woebin_adj} interactively adjust the binning breaks.
}
\examples{
\dontrun{
# Load German credit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "age.in.years", "credit.amount")]
bins = woebin(dt, y="creditability")
breaks_adj = woebin_adj(dt, y="creditability", bins)
bins_final = woebin(dt, y="creditability",
                    breaks_list=breaks_adj)

# Example II adjust two variables' breaks in brklst
binsII = woebin(germancredit, y="creditability", save_as = 'breaks')
brklst = source('breaks.R')$value
# update break list file
brklst_adj = woebin_adj(germancredit, "creditability", binsII[1:2],
                        breaks_list = brklst, save_as = 'breaks')
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_plot}}
}
