% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wd_loc.R
\name{wd_loc}
\alias{wd_loc}
\title{Define Local or Remote Working Directories}
\usage{
wd_loc(local = TRUE, local_path = getwd(), remote_path = NULL)
}
\arguments{
\item{local}{(logical) Whether you are working locally or on a remote server}

\item{local_path}{(character) File path to use if `local` is `TRUE` (defaults to `getwd()`)}

\item{remote_path}{(character) File path to use if `local` is `FALSE`}
}
\value{
(character) Either the entry of `local_path` or `remote_path` depending on whether `local` is set as true or false
}
\description{
While working on the same script both in a remote server and locally on your home computer, defining file paths can be unwieldy and may even require duplicate scripts--one for each location--that require maintenance in parallel. This function allows you to define whether you are working locally or not and specify the path to use in either case.
}
\examples{
# Set two working directory paths to toggle between

# If you are working in your local computer, set `local` to "TRUE"
wd_loc(local = TRUE,
       local_path = file.path("local path"),
       remote_path = file.path("path on server"))
       
# If you are working in a remote server, set `local` to "FALSE"
wd_loc(local = FALSE,
       local_path = file.path("local path"),
       remote_path = file.path("path on server"))
      
}
