% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq.R
\name{ExtractRun}
\alias{ExtractRun}
\title{Extract Runs with GEO Accession Number or GSM Number.}
\usage{
ExtractRun(gsm = NULL, acce = NULL, platform = NULL, parallel = TRUE, ...)
}
\arguments{
\item{gsm}{GSM number. Default: NULL (use \code{acce}).}

\item{acce}{GEO accession number. Default: NULL (use \code{gsm}).
\code{acce} and \code{gsm} cannot be both NULL.}

\item{platform}{Platform information/field. Default: NULL (all platforms).}

\item{parallel}{Logical value, whether to process GSM parallelly. Default: TRUE.}

\item{...}{Parameters for \code{\link{getGEO}}. Used when \code{acce} is not NULL.}
}
\value{
Dataframe contains GSM and Runs.
}
\description{
Extract Runs with GEO Accession Number or GSM Number.
}
\examples{
\dontrun{
GSE186003.runs <- ExtractRun(acce = "GSE186003", platform = "GPL24247", parallel = FALSE)
}
}
