% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_lagged.R
\name{print.cross_lagged}
\alias{print.cross_lagged}
\title{Print Method for Cross-Lagged Objects}
\usage{
\method{print}{cross_lagged}(x, ...)
}
\arguments{
\item{x}{An object of class "cross_lagged" containing the results from running
\code{cross_lagged}. This object includes information on lags, ACF values, and
confidence intervals.}

\item{...}{Additional parameters (currently ignored).}
}
\value{
Invisibly returns a data frame with columns for lag, ACF values, and a
significance indicator. This data frame is printed to the console for the user.
}
\description{
Prints a summary of cross-lagged correlation analysis results. This method
formats the results into a data frame showing lags, autocorrelation function (ACF) values,
and indicates significance based on the confidence intervals. Significant ACF values,
which fall outside the upper or lower confidence intervals, are marked with an asterisk (*).
}
\examples{
#Creating a sample dataset
reversal_withdrawal <- data.frame(
  phase = c(rep("baseline1", 6), rep("teratment1", 5), rep("baseline2", 5), rep("teratment2", 5)),
  time = 1:21,
  extbehavs = c(15, 10, 14, 17, 13, 12, 2, 1, 1, 0, 0, 9, 9, 11, 15, 20, 1, 0, 4, 0, 1)
)

reversal_withdrawal$synth <- sapply(reversal_withdrawal$time, function(x) {
  stats::rpois(1, x)
})

reversal_withdrawal <- as.data.frame(reversal_withdrawal)

# Using the cross_lagged function
cl_result <- cross_lagged(reversal_withdrawal, .x = "time", .y = "synth")

# Print the summary of cross-lagged analysis
print(cl_result)

}
