% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_utility_functions.R
\name{zone_table_creator}
\alias{zone_table_creator}
\title{Converts a list of zones to a \code{data.table} of zones and locations.}
\usage{
zone_table_creator(zones, keys = NULL, offset = 0L)
}
\arguments{
\item{zones}{A list of zones, elements being vectors of locations.}

\item{keys}{Character vector of one or more column names which is passed 
to \code{\link[data.table]{setkey}}.}

\item{offset}{An integer to offset the zone numbering by, in case names are
not used for the zones, and you want the zone count to start at
\code{offset} + 1.}
}
\description{
Supply a list of zones, with each element of the list being a vector
of locations. If the list is named, the output \code{data.table}
will have these names for the zones. Else, the zones are labeled
by integers from 1 to the length of the zone list.
}
\examples{
\dontrun{
zone_table_creator(list(1L, 2L, 1:2))
zone_table_creator(sets::set(sets::set(1L), 
                     sets::set(2L), sets::as.set(1:2)))
zone_table_creator(list(1L, 2L, 1:2), keys = "location")
zone_table_creator(list(1L, 2L, 1:2), keys = "zone")
zone_table_creator(list(a = "x", b = "y", c = c("x", "y")))
}
}
\keyword{internal}

